@extends('layouts.app')

@section('title', $board->name . ' | Forum')

@section('content')
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="{{ route('forum.index') }}">Forums</a>
        <span class="separator">/</span>
        <a href="{{ route('forum.index') }}">{{ $board->category->name }}</a>
        <span class="separator">/</span>
        <span class="current">{{ $board->name }}</span>
    </div>
    
    <div class="forum-board-header">
        <h1>
            {{ $board->name }}
            {{-- Show access indicators --}}
            @if(!$board->is_public)
                <span class="forum-restricted-badge" title="Restricted Access">🔒</span>
            @endif
            @if(!$board->category->is_public)
                <span class="forum-restricted-badge forum-restricted-badge--category" title="Category has restricted access">📁🔒</span>
            @endif
        </h1>
        <p>{{ $board->description }}</p>
        
        {{-- Show access requirements for transparency --}}
        @if(!$board->is_public || !$board->category->is_public)
            <div class="forum-access-notice">
                <div class="forum-access-notice-content">
                    <h4>🔐 Access Information</h4>
                    <p>This is a restricted area. 
                    @auth
                        You have been granted access based on your roles and permissions.
                    @else
                        Please log in to participate.
                    @endauth
                    </p>
                </div>
            </div>
        @endif
        
        <div class="actions">
            @auth
                {{-- Only show create thread button if user can actually post --}}
                @if($board->canAccess())
                    <a href="{{ route('forum.create-thread', $board->slug) }}" class="btn">Create New Thread</a>
                @else
                    <span class="btn btn-disabled" title="You don't have permission to create threads here">Create New Thread</span>
                @endif
            @else
                <a href="{{ route('login.steam') }}" class="btn">Login to Post</a>
            @endauth
        </div>
    </div>
    
    <div class="forum-board-threads">
        <div class="thread-header">
            <div class="title">Title</div>
            <div class="replies">Replies</div>
            <div class="views">Views</div>
            <div class="activity">Latest Activity</div>
        </div>
        
        @forelse($threads as $thread)
            <div class="thread-item {{ $thread->is_pinned ? 'pinned' : '' }} {{ $thread->is_locked ? 'locked' : '' }}">
                <div class="thread-info">
                    <h3>
                        @if($thread->is_pinned)
                            <svg class="pin-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" title="Pinned Thread">
                                <path d="M12 2L12 13"></path>
                                <circle cx="12" cy="17" r="3"></circle>
                            </svg>
                        @endif
                        
                        @if($thread->is_locked)
                            <svg class="lock-icon" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" title="Locked Thread">
                                <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                            </svg>
                        @endif
                        
                        <a href="{{ route('forum.thread', [$board->slug, $thread->slug]) }}">{{ $thread->title }}</a>
                    </h3>
                    <div class="meta">
                        Started by <a href="{{ route('users.show', $thread->user->slug) }}">{{ $thread->user->name }}</a> • {{ $thread->created_at->diffForHumans() }}
                    </div>
                </div>
                
                <div class="thread-replies">
                    {{ $thread->posts_count }}
                </div>
                
                <div class="thread-views">
                    {{ $thread->view_count }}
                </div>
                
                <div class="thread-activity">
                    @if($lastPost = $thread->lastPost())
                        <div class="time">{{ $lastPost->created_at->diffForHumans() }}</div>
                        <div class="user">by <a href="{{ route('users.show', $lastPost->user->slug) }}">{{ $lastPost->user->name }}</a></div>
                    @else
                        <div class="time">{{ $thread->created_at->diffForHumans() }}</div>
                        <div class="user">by <a href="{{ route('users.show', $thread->user->slug) }}">{{ $thread->user->name }}</a></div>
                    @endif
                </div>
            </div>
        @empty
            <div class="thread-item">
                <div class="thread-info">
                    <h3>No threads yet</h3>
                    <div class="meta">
                        @auth
                            Be the first to start a discussion!
                        @else
                            <a href="{{ route('login.steam') }}">Login</a> to start the conversation.
                        @endauth
                    </div>
                </div>
            </div>
        @endforelse
    </div>
    
    <div class="mt-4">
        {{ $threads->links() }}
    </div>

    {{-- Additional info for restricted boards --}}
    @if(!$board->is_public || !$board->category->is_public)
        <div class="forum-access-footer">
            <div class="forum-access-footer-content">
                <p><strong>Note:</strong> This board has restricted access. Content and participation may be limited based on your account permissions.</p>
            </div>
        </div>
    @endif
</div>
@endsection